<?php $__env->startSection('main'); ?>
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <div class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="m-0">
                            <i class="fas fa-cogs mr-2"></i>Company Settings
                        </h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>">Home</a></li>
                            <li class="breadcrumb-item active">Settings</li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <?php if(session('success')): ?>
                    <div class="alert alert-success alert-dismissible fade show">
                        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                        <i class="icon fas fa-check"></i>
                        <?php echo e(session('success')); ?>

                    </div>
                <?php endif; ?>

                <div class="row">
                    <!-- Company Information Overview -->
                    <div class="col-md-8">
                        <div class="card card-primary">
                            <div class="card-header">
                                <h3 class="card-title">
                                    <i class="fas fa-building mr-2"></i>Company Information
                                </h3>
                                <div class="card-tools">
                                    <a href="<?php echo e(route('settings.edit', 1)); ?>" class="btn btn-tool btn-sm">
                                        <i class="fas fa-edit"></i> Edit
                                    </a>
                                </div>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-6">
                                        <strong><i class="fas fa-tag mr-1"></i> Company Name</strong>
                                        <p class="text-muted"><?php echo e($settings->company_name ?? 'Not Set'); ?></p>

                                        <strong><i class="fas fa-phone mr-1"></i> Phone Number</strong>
                                        <p class="text-muted"><?php echo e($settings->number ?? 'Not Set'); ?></p>

                                        <strong><i class="fas fa-envelope mr-1"></i> Email</strong>
                                        <p class="text-muted"><?php echo e($settings->company_email ?? 'Not Set'); ?></p>

                                        <strong><i class="fas fa-globe mr-1"></i> Website</strong>
                                        <p class="text-muted">
                                            <?php if($settings->website): ?>
                                                <a href="<?php echo e($settings->website); ?>" target="_blank"><?php echo e($settings->website); ?></a>
                                            <?php else: ?>
                                                Not Set
                                            <?php endif; ?>
                                        </p>
                                    </div>
                                    <div class="col-md-6">
                                        <strong><i class="fas fa-map-marker-alt mr-1"></i> Address</strong>
                                        <p class="text-muted"><?php echo e($settings->address ?? 'Not Set'); ?></p>

                                        <strong><i class="fas fa-certificate mr-1"></i> Registration Number</strong>
                                        <p class="text-muted"><?php echo e($settings->company_registration_number ?? 'Not Set'); ?></p>

                                        <strong><i class="fas fa-clock mr-1"></i> Time Zone</strong>
                                        <p class="text-muted"><?php echo e($settings->time_zone ?? 'Not Set'); ?></p>

                                        <strong><i class="fas fa-dollar-sign mr-1"></i> Currency</strong>
                                        <p class="text-muted"><?php echo e($settings->currency ?? 'Not Set'); ?></p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Company Logo and Quick Actions -->
                    <div class="col-md-4">
                        <div class="card card-info">
                            <div class="card-header">
                                <h3 class="card-title">
                                    <i class="fas fa-image mr-2"></i>Company Logo
                                </h3>
                            </div>
                            <div class="card-body text-center">
                                <?php if($settings->logo_path): ?>
                                    <img src="<?php echo e(asset('logos/' . $settings->logo_path)); ?>" 
                                         alt="Company Logo" 
                                         class="img-fluid img-thumbnail mb-3"
                                         style="max-height: 200px;">
                                <?php else: ?>
                                    <div class="text-center py-4">
                                        <i class="fas fa-image fa-4x text-muted"></i>
                                        <p class="text-muted mt-2">No logo uploaded</p>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>

                        <!-- Quick Actions Card -->
                        <div class="card card-secondary">
                            <div class="card-header">
                                <h3 class="card-title">
                                    <i class="fas fa-tools mr-2"></i>Quick Actions
                                </h3>
                            </div>
                            <div class="card-body">
                                <a href="<?php echo e(route('settings.edit', 1)); ?>" class="btn btn-primary btn-block mb-2">
                                    <i class="fas fa-edit mr-1"></i> Edit Settings
                                </a>
                                <button type="button" class="btn btn-info btn-block mb-2" onclick="previewInvoice()">
                                    <i class="fas fa-eye mr-1"></i> Preview Invoice
                                </button>
                                <button type="button" class="btn btn-success btn-block" onclick="testPosSettings()">
                                    <i class="fas fa-cash-register mr-1"></i> Test POS Settings
                                </button>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- POS Configuration -->
                <div class="row">
                    <div class="col-12">
                        <div class="card card-warning">
                            <div class="card-header">
                                <h3 class="card-title">
                                    <i class="fas fa-cash-register mr-2"></i>POS Configuration
                                </h3>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-3">
                                        <div class="info-box">
                                            <span class="info-box-icon bg-warning">
                                                <i class="fas fa-tags"></i>
                                            </span>
                                            <div class="info-box-content">
                                                <span class="info-box-text">Price Type</span>
                                                <span class="info-box-number">
                                                    <?php echo e(ucfirst($settings->pos_price_type ?? 'Not Set')); ?>

                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="info-box">
                                            <span class="info-box-icon bg-info">
                                                <i class="fas fa-calculator"></i>
                                            </span>
                                            <div class="info-box-content">
                                                <span class="info-box-text">Price Value</span>
                                                <span class="info-box-number">
                                                    <?php if($settings->pos_price_type == 'percentage'): ?>
                                                        <?php echo e($settings->pos_price_value ?? 0); ?>%
                                                    <?php else: ?>
                                                        <?php echo e($settings->currency ?? '$'); ?><?php echo e($settings->pos_price_value ?? 0); ?>

                                                    <?php endif; ?>
                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="alert alert-info">
                                            <h5><i class="icon fas fa-info"></i> POS Pricing Information</h5>
                                            <?php if($settings->pos_price_type == 'percentage'): ?>
                                                POS prices will be calculated by adding <strong><?php echo e($settings->pos_price_value ?? 0); ?>%</strong> to the base price.
                                            <?php else: ?>
                                                POS prices will be calculated by adding a fixed amount of <strong><?php echo e($settings->currency ?? '$'); ?><?php echo e($settings->pos_price_value ?? 0); ?></strong> to the base price.
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- System Information -->
                <div class="row">
                    <div class="col-12">
                        <div class="card card-dark">
                            <div class="card-header">
                                <h3 class="card-title">
                                    <i class="fas fa-server mr-2"></i>System Information
                                </h3>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-4">
                                        <strong>Last Updated:</strong>
                                        <p class="text-muted"><?php echo e($settings->updated_at ? $settings->updated_at->format('M d, Y h:i A') : 'Never'); ?></p>
                                    </div>
                                    <div class="col-md-4">
                                        <strong>Created:</strong>
                                        <p class="text-muted"><?php echo e($settings->created_at ? $settings->created_at->format('M d, Y h:i A') : 'Unknown'); ?></p>
                                    </div>
                                    <div class="col-md-4">
                                        <strong>Tenant ID:</strong>
                                        <p class="text-muted"><?php echo e($settings->tenant_id ?? 'N/A'); ?></p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>

    <!-- Scripts -->
    <script>
        function previewInvoice() {
            // You can implement invoice preview functionality here
            alert('Invoice preview functionality can be implemented here');
        }

        function testPosSettings() {
            // You can implement POS settings test functionality here
            const priceType = '<?php echo e($settings->pos_price_type); ?>';
            const priceValue = <?php echo e($settings->pos_price_value ?? 0); ?>;
            const currency = '<?php echo e($settings->currency ?? "$"); ?>';
            
            let message = 'POS Settings Test:\n\n';
            message += 'Price Type: ' + priceType + '\n';
            message += 'Price Value: ';
            
            if (priceType === 'percentage') {
                message += priceValue + '%\n\n';
                message += 'Example: Base price $100 → POS price $' + (100 + (100 * priceValue / 100));
            } else {
                message += currency + priceValue + '\n\n';
                message += 'Example: Base price $100 → POS price $' + (100 + priceValue);
            }
            
            alert(message);
        }
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\pos v24.4\resources\views/settings/index.blade.php ENDPATH**/ ?>